	function [G, Z, R_ZEROS, P, Wsnew] = CA_CONST_R_POLES_S(Wc, Ws, Amin, N)	
	
	% 	Computes the denormalized poles, zeros and gain constant for  
	%	an analog lowpass Cauer filter with constant pole radius.
	%	Minimizes the stopband edge.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar, 1999-9-27
    % 	Modified by: 	  
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	if ~(abs(N-round(N)) < eps)
		error('N must be an integeer')  
		return
	end

	x = 10^(0.1*Amin);
	Amax = 10*log10(x/(x-1));
	
	[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wc, Ws, Amax, Amin, N);
	
	G = real(prod(-P)/prod(-Z));	% Gain constant
	if (~rem(N, 2)) 				% N is even, hence correct the gain
		Apn = Amax*log(10)/20;
		epsilon2 = 2*exp(Apn)*sinh(Apn);
		G = G/sqrt(1 + epsilon2);
	end			
	
